package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.EarthObservationJobArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputConfigInput(
    previousEarthObservationJobArn: Optional[EarthObservationJobArn] =
      Optional.Absent,
    rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigInput = {
    import InputConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigInput
      .builder()
      .optionallyWith(
        previousEarthObservationJobArn.map(value =>
          EarthObservationJobArn.unwrap(value): java.lang.String
        )
      )(_.previousEarthObservationJobArn)
      .optionallyWith(
        rasterDataCollectionQuery.map(value => value.buildAwsValue())
      )(_.rasterDataCollectionQuery)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.InputConfigInput.wrap(buildAwsValue())
}
object InputConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.InputConfigInput =
      zio.aws.sagemakergeospatial.model.InputConfigInput(
        previousEarthObservationJobArn.map(value => value),
        rasterDataCollectionQuery.map(value => value.asEditable)
      )
    def previousEarthObservationJobArn: Optional[EarthObservationJobArn]
    def rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput.ReadOnly
    ]
    def getPreviousEarthObservationJobArn
        : ZIO[Any, AwsError, EarthObservationJobArn] =
      AwsError.unwrapOptionField(
        "previousEarthObservationJobArn",
        previousEarthObservationJobArn
      )
    def getRasterDataCollectionQuery: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rasterDataCollectionQuery",
      rasterDataCollectionQuery
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigInput
  ) extends zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly {
    override val previousEarthObservationJobArn
        : Optional[EarthObservationJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.previousEarthObservationJobArn())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives
          .EarthObservationJobArn(value)
      )
    override val rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rasterDataCollectionQuery())
      .map(value =>
        zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigInput
  ): zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly = new Wrapper(
    impl
  )
}
