package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomIndicesInput(
    operations: Optional[
      Iterable[zio.aws.sagemakergeospatial.model.Operation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.CustomIndicesInput = {
    import CustomIndicesInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.CustomIndicesInput
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.CustomIndicesInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.CustomIndicesInput.wrap(buildAwsValue())
}
object CustomIndicesInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.CustomIndicesInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.CustomIndicesInput =
      zio.aws.sagemakergeospatial.model.CustomIndicesInput(
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def operations
        : Optional[List[zio.aws.sagemakergeospatial.model.Operation.ReadOnly]]
    def getOperations: ZIO[Any, AwsError, List[
      zio.aws.sagemakergeospatial.model.Operation.ReadOnly
    ]] = AwsError.unwrapOptionField("operations", operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.CustomIndicesInput
  ) extends zio.aws.sagemakergeospatial.model.CustomIndicesInput.ReadOnly {
    override val operations
        : Optional[List[zio.aws.sagemakergeospatial.model.Operation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemakergeospatial.model.Operation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.CustomIndicesInput
  ): zio.aws.sagemakergeospatial.model.CustomIndicesInput.ReadOnly =
    new Wrapper(impl)
}
