package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.{KmsKey, S3Uri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ZonalStatisticsConfigInput(
    statistics: Iterable[zio.aws.sagemakergeospatial.model.ZonalStatistics],
    targetBands: Optional[Iterable[String]] = Optional.Absent,
    zoneS3Path: S3Uri,
    zoneS3PathKmsKeyId: Optional[KmsKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput = {
    import ZonalStatisticsConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput
      .builder()
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        targetBands.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.targetBands)
      .zoneS3Path(S3Uri.unwrap(zoneS3Path): java.lang.String)
      .optionallyWith(
        zoneS3PathKmsKeyId.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.zoneS3PathKmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput
      .wrap(buildAwsValue())
}
object ZonalStatisticsConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput =
      zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput(
        statistics,
        targetBands.map(value => value),
        zoneS3Path,
        zoneS3PathKmsKeyId.map(value => value)
      )
    def statistics: List[zio.aws.sagemakergeospatial.model.ZonalStatistics]
    def targetBands: Optional[List[String]]
    def zoneS3Path: S3Uri
    def zoneS3PathKmsKeyId: Optional[KmsKey]
    def getStatistics: ZIO[Any, Nothing, List[
      zio.aws.sagemakergeospatial.model.ZonalStatistics
    ]] = ZIO.succeed(statistics)
    def getTargetBands: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("targetBands", targetBands)
    def getZoneS3Path: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(zoneS3Path)
    def getZoneS3PathKmsKeyId: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("zoneS3PathKmsKeyId", zoneS3PathKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput
  ) extends zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput.ReadOnly {
    override val statistics
        : List[zio.aws.sagemakergeospatial.model.ZonalStatistics] = impl
      .statistics()
      .asScala
      .map { item =>
        zio.aws.sagemakergeospatial.model.ZonalStatistics.wrap(item)
      }
      .toList
    override val targetBands: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetBands())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val zoneS3Path: S3Uri =
      zio.aws.sagemakergeospatial.model.primitives.S3Uri(impl.zoneS3Path())
    override val zoneS3PathKmsKeyId: Optional[KmsKey] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneS3PathKmsKeyId())
      .map(value => zio.aws.sagemakergeospatial.model.primitives.KmsKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput
  ): zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput.ReadOnly =
    new Wrapper(impl)
}
