package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MapMatchingConfig(
    idAttributeName: String,
    timestampAttributeName: String,
    xAttributeName: String,
    yAttributeName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.MapMatchingConfig = {
    import MapMatchingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.MapMatchingConfig
      .builder()
      .idAttributeName(idAttributeName: java.lang.String)
      .timestampAttributeName(timestampAttributeName: java.lang.String)
      .xAttributeName(xAttributeName: java.lang.String)
      .yAttributeName(yAttributeName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.MapMatchingConfig.ReadOnly =
    zio.aws.sagemakergeospatial.model.MapMatchingConfig.wrap(buildAwsValue())
}
object MapMatchingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.MapMatchingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.MapMatchingConfig =
      zio.aws.sagemakergeospatial.model.MapMatchingConfig(
        idAttributeName,
        timestampAttributeName,
        xAttributeName,
        yAttributeName
      )
    def idAttributeName: String
    def timestampAttributeName: String
    def xAttributeName: String
    def yAttributeName: String
    def getIdAttributeName: ZIO[Any, Nothing, String] =
      ZIO.succeed(idAttributeName)
    def getTimestampAttributeName: ZIO[Any, Nothing, String] =
      ZIO.succeed(timestampAttributeName)
    def getXAttributeName: ZIO[Any, Nothing, String] =
      ZIO.succeed(xAttributeName)
    def getYAttributeName: ZIO[Any, Nothing, String] =
      ZIO.succeed(yAttributeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.MapMatchingConfig
  ) extends zio.aws.sagemakergeospatial.model.MapMatchingConfig.ReadOnly {
    override val idAttributeName: String = impl.idAttributeName(): String
    override val timestampAttributeName: String =
      impl.timestampAttributeName(): String
    override val xAttributeName: String = impl.xAttributeName(): String
    override val yAttributeName: String = impl.yAttributeName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.MapMatchingConfig
  ): zio.aws.sagemakergeospatial.model.MapMatchingConfig.ReadOnly = new Wrapper(
    impl
  )
}
