package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.EarthObservationJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEarthObservationJobRequest(arn: EarthObservationJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest = {
    import DeleteEarthObservationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest
      .builder()
      .arn(EarthObservationJobArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobRequest
      .wrap(buildAwsValue())
}
object DeleteEarthObservationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobRequest =
      zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobRequest(arn)
    def arn: EarthObservationJobArn
    def getArn: ZIO[Any, Nothing, EarthObservationJobArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest
  ) extends zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobRequest.ReadOnly {
    override val arn: EarthObservationJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .EarthObservationJobArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest
  ): zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobRequest.ReadOnly =
    new Wrapper(impl)
}
