package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.{
  ExecutionRoleArn,
  ExportVectorEnrichmentJobInputClientTokenString,
  VectorEnrichmentJobArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportVectorEnrichmentJobRequest(
    arn: VectorEnrichmentJobArn,
    clientToken: Optional[ExportVectorEnrichmentJobInputClientTokenString] =
      Optional.Absent,
    executionRoleArn: ExecutionRoleArn,
    outputConfig: zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest = {
    import ExportVectorEnrichmentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
      .builder()
      .arn(VectorEnrichmentJobArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        clientToken.map(value =>
          ExportVectorEnrichmentJobInputClientTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.clientToken)
      .executionRoleArn(
        ExecutionRoleArn.unwrap(executionRoleArn): java.lang.String
      )
      .outputConfig(outputConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
      .wrap(buildAwsValue())
}
object ExportVectorEnrichmentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest =
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest(
        arn,
        clientToken.map(value => value),
        executionRoleArn,
        outputConfig.asEditable
      )
    def arn: VectorEnrichmentJobArn
    def clientToken: Optional[ExportVectorEnrichmentJobInputClientTokenString]
    def executionRoleArn: ExecutionRoleArn
    def outputConfig
        : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.ReadOnly
    def getArn: ZIO[Any, Nothing, VectorEnrichmentJobArn] = ZIO.succeed(arn)
    def getClientToken
        : ZIO[Any, AwsError, ExportVectorEnrichmentJobInputClientTokenString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExecutionRoleArn: ZIO[Any, Nothing, ExecutionRoleArn] =
      ZIO.succeed(executionRoleArn)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
  ) extends zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest.ReadOnly {
    override val arn: VectorEnrichmentJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .VectorEnrichmentJobArn(impl.arn())
    override val clientToken
        : Optional[ExportVectorEnrichmentJobInputClientTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.sagemakergeospatial.model.primitives
            .ExportVectorEnrichmentJobInputClientTokenString(value)
        )
    override val executionRoleArn: ExecutionRoleArn =
      zio.aws.sagemakergeospatial.model.primitives
        .ExecutionRoleArn(impl.executionRoleArn())
    override val outputConfig
        : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig
        .wrap(impl.outputConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
  ): zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest.ReadOnly =
    new Wrapper(impl)
}
