package zio.aws.sagemakergeospatial.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.{
  Integer,
  SyntheticTimestamp_date_time,
  VectorEnrichmentJobArn
}
import scala.jdk.CollectionConverters._
final case class ListVectorEnrichmentJobOutputConfig(
    arn: VectorEnrichmentJobArn,
    creationTime: SyntheticTimestamp_date_time,
    durationInSeconds: Integer,
    name: String,
    status: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus,
    tags: Optional[Map[String, String]] = Optional.Absent,
    `type`: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig = {
    import ListVectorEnrichmentJobOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig
      .builder()
      .arn(VectorEnrichmentJobArn.unwrap(arn): java.lang.String)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .durationInSeconds(durationInSeconds: java.lang.Integer)
      .name(name: java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly =
    zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig
      .wrap(buildAwsValue())
}
object ListVectorEnrichmentJobOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig =
      zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig(
        arn,
        creationTime,
        durationInSeconds,
        name,
        status,
        tags.map(value => value),
        `type`
      )
    def arn: VectorEnrichmentJobArn
    def creationTime: SyntheticTimestamp_date_time
    def durationInSeconds: Integer
    def name: String
    def status: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus
    def tags: Optional[Map[String, String]]
    def `type`: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
    def getArn: ZIO[Any, Nothing, VectorEnrichmentJobArn] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getDurationInSeconds: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(durationInSeconds)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus
    ] = ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig
  ) extends zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly {
    override val arn: VectorEnrichmentJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .VectorEnrichmentJobArn(impl.arn())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.sagemakergeospatial.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val durationInSeconds: Integer = impl.durationInSeconds(): Integer
    override val name: String = impl.name(): String
    override val status
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus
        .wrap(impl.status())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
        .wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig
  ): zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly =
    new Wrapper(impl)
}
