package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VectorEnrichmentJobConfig(
    mapMatchingConfig: Optional[
      zio.aws.sagemakergeospatial.model.MapMatchingConfig
    ] = Optional.Absent,
    reverseGeocodingConfig: Optional[
      zio.aws.sagemakergeospatial.model.ReverseGeocodingConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobConfig = {
    import VectorEnrichmentJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobConfig
      .builder()
      .optionallyWith(mapMatchingConfig.map(value => value.buildAwsValue()))(
        _.mapMatchingConfig
      )
      .optionallyWith(
        reverseGeocodingConfig.map(value => value.buildAwsValue())
      )(_.reverseGeocodingConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly =
    zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig
      .wrap(buildAwsValue())
}
object VectorEnrichmentJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig(
        mapMatchingConfig.map(value => value.asEditable),
        reverseGeocodingConfig.map(value => value.asEditable)
      )
    def mapMatchingConfig
        : Optional[zio.aws.sagemakergeospatial.model.MapMatchingConfig.ReadOnly]
    def reverseGeocodingConfig: Optional[
      zio.aws.sagemakergeospatial.model.ReverseGeocodingConfig.ReadOnly
    ]
    def getMapMatchingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.MapMatchingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("mapMatchingConfig", mapMatchingConfig)
    def getReverseGeocodingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ReverseGeocodingConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "reverseGeocodingConfig",
      reverseGeocodingConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobConfig
  ) extends zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly {
    override val mapMatchingConfig: Optional[
      zio.aws.sagemakergeospatial.model.MapMatchingConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mapMatchingConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.MapMatchingConfig.wrap(value)
      )
    override val reverseGeocodingConfig: Optional[
      zio.aws.sagemakergeospatial.model.ReverseGeocodingConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reverseGeocodingConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.ReverseGeocodingConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobConfig
  ): zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly =
    new Wrapper(impl)
}
