package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudRemovalConfigInput(
    algorithmName: Optional[
      zio.aws.sagemakergeospatial.model.AlgorithmNameCloudRemoval
    ] = Optional.Absent,
    interpolationValue: Optional[String] = Optional.Absent,
    targetBands: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.CloudRemovalConfigInput = {
    import CloudRemovalConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.CloudRemovalConfigInput
      .builder()
      .optionallyWith(algorithmName.map(value => value.unwrap))(_.algorithmName)
      .optionallyWith(interpolationValue.map(value => value: java.lang.String))(
        _.interpolationValue
      )
      .optionallyWith(
        targetBands.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.targetBands)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput
      .wrap(buildAwsValue())
}
object CloudRemovalConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.CloudRemovalConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput =
      zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput(
        algorithmName.map(value => value),
        interpolationValue.map(value => value),
        targetBands.map(value => value)
      )
    def algorithmName
        : Optional[zio.aws.sagemakergeospatial.model.AlgorithmNameCloudRemoval]
    def interpolationValue: Optional[String]
    def targetBands: Optional[List[String]]
    def getAlgorithmName: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.AlgorithmNameCloudRemoval
    ] = AwsError.unwrapOptionField("algorithmName", algorithmName)
    def getInterpolationValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("interpolationValue", interpolationValue)
    def getTargetBands: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("targetBands", targetBands)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.CloudRemovalConfigInput
  ) extends zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput.ReadOnly {
    override val algorithmName: Optional[
      zio.aws.sagemakergeospatial.model.AlgorithmNameCloudRemoval
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmName())
      .map(value =>
        zio.aws.sagemakergeospatial.model.AlgorithmNameCloudRemoval.wrap(value)
      )
    override val interpolationValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.interpolationValue())
      .map(value => value: String)
    override val targetBands: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetBands())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.CloudRemovalConfigInput
  ): zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput.ReadOnly =
    new Wrapper(impl)
}
