package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EarthObservationJobErrorDetails(
    message: Optional[String] = Optional.Absent,
    `type`: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobErrorType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobErrorDetails = {
    import EarthObservationJobErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobErrorDetails
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails.ReadOnly =
    zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails
      .wrap(buildAwsValue())
}
object EarthObservationJobErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails =
      zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails(
        message.map(value => value),
        `type`.map(value => value)
      )
    def message: Optional[String]
    def `type`: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobErrorType
    ]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.EarthObservationJobErrorType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobErrorDetails
  ) extends zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val `type`: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobErrorType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.sagemakergeospatial.model.EarthObservationJobErrorType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobErrorDetails
  ): zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails.ReadOnly =
    new Wrapper(impl)
}
