package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartVectorEnrichmentJobRequest(
    clientToken: Optional[String] = Optional.Absent,
    executionRoleArn: String,
    inputConfig: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig,
    jobConfig: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig,
    kmsKeyId: Optional[String] = Optional.Absent,
    name: String,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest = {
    import StartVectorEnrichmentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .executionRoleArn(executionRoleArn: java.lang.String)
      .inputConfig(inputConfig.buildAwsValue())
      .jobConfig(jobConfig.buildAwsValue())
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .name(name: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
      .wrap(buildAwsValue())
}
object StartVectorEnrichmentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest =
      zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest(
        clientToken.map(value => value),
        executionRoleArn,
        inputConfig.asEditable,
        jobConfig.asEditable,
        kmsKeyId.map(value => value),
        name,
        tags.map(value => value)
      )
    def clientToken: Optional[String]
    def executionRoleArn: String
    def inputConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly
    def jobConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly
    def kmsKeyId: Optional[String]
    def name: String
    def tags: Optional[Map[String, String]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExecutionRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(executionRoleArn)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly
    ] = ZIO.succeed(jobConfig)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
  ) extends zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val executionRoleArn: String = impl.executionRoleArn(): String
    override val inputConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig
        .wrap(impl.inputConfig())
    override val jobConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig
        .wrap(impl.jobConfig())
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val name: String = impl.name(): String
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
  ): zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest.ReadOnly =
    new Wrapper(impl)
}
