package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VectorEnrichmentJobInputConfig(
    dataSourceConfig: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput,
    documentType: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDocumentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobInputConfig = {
    import VectorEnrichmentJobInputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobInputConfig
      .builder()
      .dataSourceConfig(dataSourceConfig.buildAwsValue())
      .documentType(documentType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly =
    zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig
      .wrap(buildAwsValue())
}
object VectorEnrichmentJobInputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobInputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig(
        dataSourceConfig.asEditable,
        documentType
      )
    def dataSourceConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput.ReadOnly
    def documentType
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDocumentType
    def getDataSourceConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput.ReadOnly
    ] = ZIO.succeed(dataSourceConfig)
    def getDocumentType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDocumentType
    ] = ZIO.succeed(documentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobInputConfig
  ) extends zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly {
    override val dataSourceConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput
        .wrap(impl.dataSourceConfig())
    override val documentType
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDocumentType =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDocumentType
        .wrap(impl.documentType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobInputConfig
  ): zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly =
    new Wrapper(impl)
}
