package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputConfigOutput(
    dataSourceConfig: Optional[
      zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput
    ] = Optional.Absent,
    previousEarthObservationJobArn: Optional[String] = Optional.Absent,
    rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput = {
    import InputConfigOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput
      .builder()
      .optionallyWith(dataSourceConfig.map(value => value.buildAwsValue()))(
        _.dataSourceConfig
      )
      .optionallyWith(
        previousEarthObservationJobArn.map(value => value: java.lang.String)
      )(_.previousEarthObservationJobArn)
      .optionallyWith(
        rasterDataCollectionQuery.map(value => value.buildAwsValue())
      )(_.rasterDataCollectionQuery)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly =
    zio.aws.sagemakergeospatial.model.InputConfigOutput.wrap(buildAwsValue())
}
object InputConfigOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.InputConfigOutput =
      zio.aws.sagemakergeospatial.model.InputConfigOutput(
        dataSourceConfig.map(value => value.asEditable),
        previousEarthObservationJobArn.map(value => value),
        rasterDataCollectionQuery.map(value => value.asEditable)
      )
    def dataSourceConfig: Optional[
      zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.ReadOnly
    ]
    def previousEarthObservationJobArn: Optional[String]
    def rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly
    ]
    def getDataSourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("dataSourceConfig", dataSourceConfig)
    def getPreviousEarthObservationJobArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "previousEarthObservationJobArn",
        previousEarthObservationJobArn
      )
    def getRasterDataCollectionQuery: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rasterDataCollectionQuery",
      rasterDataCollectionQuery
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput
  ) extends zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly {
    override val dataSourceConfig: Optional[
      zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.wrap(value)
      )
    override val previousEarthObservationJobArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousEarthObservationJobArn())
        .map(value => value: String)
    override val rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rasterDataCollectionQuery())
      .map(value =>
        zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput
  ): zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly = new Wrapper(
    impl
  )
}
