package zio.aws.sagemakergeospatial.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.{Integer, Timestamp}
import scala.jdk.CollectionConverters._
final case class ListEarthObservationJobOutputConfig(
    arn: String,
    creationTime: Timestamp,
    durationInSeconds: Integer,
    name: String,
    operationType: String,
    status: zio.aws.sagemakergeospatial.model.EarthObservationJobStatus,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig = {
    import ListEarthObservationJobOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig
      .builder()
      .arn(arn: java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .durationInSeconds(durationInSeconds: java.lang.Integer)
      .name(name: java.lang.String)
      .operationType(operationType: java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly =
    zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig
      .wrap(buildAwsValue())
}
object ListEarthObservationJobOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig =
      zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig(
        arn,
        creationTime,
        durationInSeconds,
        name,
        operationType,
        status,
        tags.map(value => value)
      )
    def arn: String
    def creationTime: Timestamp
    def durationInSeconds: Integer
    def name: String
    def operationType: String
    def status: zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
    def tags: Optional[Map[String, String]]
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getDurationInSeconds: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(durationInSeconds)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getOperationType: ZIO[Any, Nothing, String] = ZIO.succeed(operationType)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
    ] = ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig
  ) extends zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly {
    override val arn: String = impl.arn(): String
    override val creationTime: Timestamp =
      zio.aws.sagemakergeospatial.model.primitives
        .Timestamp(impl.creationTime())
    override val durationInSeconds: Integer = impl.durationInSeconds(): Integer
    override val name: String = impl.name(): String
    override val operationType: String = impl.operationType(): String
    override val status
        : zio.aws.sagemakergeospatial.model.EarthObservationJobStatus =
      zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
        .wrap(impl.status())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig
  ): zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly =
    new Wrapper(impl)
}
