package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.EarthObservationJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopEarthObservationJobRequest(arn: EarthObservationJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.StopEarthObservationJobRequest = {
    import StopEarthObservationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.StopEarthObservationJobRequest
      .builder()
      .arn(EarthObservationJobArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.StopEarthObservationJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.StopEarthObservationJobRequest
      .wrap(buildAwsValue())
}
object StopEarthObservationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.StopEarthObservationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.StopEarthObservationJobRequest =
      zio.aws.sagemakergeospatial.model.StopEarthObservationJobRequest(arn)
    def arn: EarthObservationJobArn
    def getArn: ZIO[Any, Nothing, EarthObservationJobArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StopEarthObservationJobRequest
  ) extends zio.aws.sagemakergeospatial.model.StopEarthObservationJobRequest.ReadOnly {
    override val arn: EarthObservationJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .EarthObservationJobArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StopEarthObservationJobRequest
  ): zio.aws.sagemakergeospatial.model.StopEarthObservationJobRequest.ReadOnly =
    new Wrapper(impl)
}
