package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VectorEnrichmentJobErrorDetails(
    errorMessage: Optional[String] = Optional.Absent,
    errorType: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails = {
    import VectorEnrichmentJobErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails
      .builder()
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(errorType.map(value => value.unwrap))(_.errorType)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails.ReadOnly =
    zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails
      .wrap(buildAwsValue())
}
object VectorEnrichmentJobErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails(
        errorMessage.map(value => value),
        errorType.map(value => value)
      )
    def errorMessage: Optional[String]
    def errorType: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorType
    ]
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorType
    ] = AwsError.unwrapOptionField("errorType", errorType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails
  ) extends zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails.ReadOnly {
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val errorType: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errorType())
      .map(value =>
        zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails
  ): zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails.ReadOnly =
    new Wrapper(impl)
}
