package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VectorEnrichmentJobExportErrorDetails(
    message: Optional[String] = Optional.Absent,
    `type`: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails = {
    import VectorEnrichmentJobExportErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails.ReadOnly =
    zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails
      .wrap(buildAwsValue())
}
object VectorEnrichmentJobExportErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails(
        message.map(value => value),
        `type`.map(value => value)
      )
    def message: Optional[String]
    def `type`: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorType
    ]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails
  ) extends zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val `type`: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails
  ): zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails.ReadOnly =
    new Wrapper(impl)
}
