package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.{S3Uri, KmsKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VectorEnrichmentJobS3Data(
    kmsKeyId: Optional[KmsKey] = Optional.Absent,
    s3Uri: S3Uri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobS3Data = {
    import VectorEnrichmentJobS3Data.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobS3Data
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data.ReadOnly =
    zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data
      .wrap(buildAwsValue())
}
object VectorEnrichmentJobS3Data {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobS3Data
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data =
      zio.aws.sagemakergeospatial.model
        .VectorEnrichmentJobS3Data(kmsKeyId.map(value => value), s3Uri)
    def kmsKeyId: Optional[KmsKey]
    def s3Uri: S3Uri
    def getKmsKeyId: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobS3Data
  ) extends zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data.ReadOnly {
    override val kmsKeyId: Optional[KmsKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemakergeospatial.model.primitives.KmsKey(value))
    override val s3Uri: S3Uri =
      zio.aws.sagemakergeospatial.model.primitives.S3Uri(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobS3Data
  ): zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data.ReadOnly =
    new Wrapper(impl)
}
