package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.EarthObservationJobArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputConfigOutput(
    previousEarthObservationJobArn: Optional[EarthObservationJobArn] =
      Optional.Absent,
    rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput = {
    import InputConfigOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput
      .builder()
      .optionallyWith(
        previousEarthObservationJobArn.map(value =>
          EarthObservationJobArn.unwrap(value): java.lang.String
        )
      )(_.previousEarthObservationJobArn)
      .optionallyWith(
        rasterDataCollectionQuery.map(value => value.buildAwsValue())
      )(_.rasterDataCollectionQuery)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly =
    zio.aws.sagemakergeospatial.model.InputConfigOutput.wrap(buildAwsValue())
}
object InputConfigOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.InputConfigOutput =
      zio.aws.sagemakergeospatial.model.InputConfigOutput(
        previousEarthObservationJobArn.map(value => value),
        rasterDataCollectionQuery.map(value => value.asEditable)
      )
    def previousEarthObservationJobArn: Optional[EarthObservationJobArn]
    def rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly
    ]
    def getPreviousEarthObservationJobArn
        : ZIO[Any, AwsError, EarthObservationJobArn] =
      AwsError.unwrapOptionField(
        "previousEarthObservationJobArn",
        previousEarthObservationJobArn
      )
    def getRasterDataCollectionQuery: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rasterDataCollectionQuery",
      rasterDataCollectionQuery
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput
  ) extends zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly {
    override val previousEarthObservationJobArn
        : Optional[EarthObservationJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.previousEarthObservationJobArn())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives
          .EarthObservationJobArn(value)
      )
    override val rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rasterDataCollectionQuery())
      .map(value =>
        zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput
  ): zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly = new Wrapper(
    impl
  )
}
