package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.{
  StartVectorEnrichmentJobInputNameString,
  KmsKey,
  ExecutionRoleArn,
  StartVectorEnrichmentJobInputClientTokenString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartVectorEnrichmentJobRequest(
    clientToken: Optional[StartVectorEnrichmentJobInputClientTokenString] =
      Optional.Absent,
    executionRoleArn: ExecutionRoleArn,
    inputConfig: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig,
    jobConfig: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig,
    kmsKeyId: Optional[KmsKey] = Optional.Absent,
    name: StartVectorEnrichmentJobInputNameString,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest = {
    import StartVectorEnrichmentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          StartVectorEnrichmentJobInputClientTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.clientToken)
      .executionRoleArn(
        ExecutionRoleArn.unwrap(executionRoleArn): java.lang.String
      )
      .inputConfig(inputConfig.buildAwsValue())
      .jobConfig(jobConfig.buildAwsValue())
      .optionallyWith(
        kmsKeyId.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .name(
        StartVectorEnrichmentJobInputNameString.unwrap(name): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
      .wrap(buildAwsValue())
}
object StartVectorEnrichmentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest =
      zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest(
        clientToken.map(value => value),
        executionRoleArn,
        inputConfig.asEditable,
        jobConfig.asEditable,
        kmsKeyId.map(value => value),
        name,
        tags.map(value => value)
      )
    def clientToken: Optional[StartVectorEnrichmentJobInputClientTokenString]
    def executionRoleArn: ExecutionRoleArn
    def inputConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly
    def jobConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly
    def kmsKeyId: Optional[KmsKey]
    def name: StartVectorEnrichmentJobInputNameString
    def tags: Optional[Map[String, String]]
    def getClientToken
        : ZIO[Any, AwsError, StartVectorEnrichmentJobInputClientTokenString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExecutionRoleArn: ZIO[Any, Nothing, ExecutionRoleArn] =
      ZIO.succeed(executionRoleArn)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly
    ] = ZIO.succeed(jobConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getName: ZIO[Any, Nothing, StartVectorEnrichmentJobInputNameString] =
      ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
  ) extends zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest.ReadOnly {
    override val clientToken
        : Optional[StartVectorEnrichmentJobInputClientTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.sagemakergeospatial.model.primitives
            .StartVectorEnrichmentJobInputClientTokenString(value)
        )
    override val executionRoleArn: ExecutionRoleArn =
      zio.aws.sagemakergeospatial.model.primitives
        .ExecutionRoleArn(impl.executionRoleArn())
    override val inputConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig
        .wrap(impl.inputConfig())
    override val jobConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig
        .wrap(impl.jobConfig())
    override val kmsKeyId: Optional[KmsKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemakergeospatial.model.primitives.KmsKey(value))
    override val name: StartVectorEnrichmentJobInputNameString =
      zio.aws.sagemakergeospatial.model.primitives
        .StartVectorEnrichmentJobInputNameString(impl.name())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest
  ): zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobRequest.ReadOnly =
    new Wrapper(impl)
}
