package zio.aws.sagemakergeospatial.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.{
  KmsKey,
  ExecutionRoleArn,
  Integer,
  SyntheticTimestamp_date_time
}
import scala.jdk.CollectionConverters._
final case class GetEarthObservationJobResponse(
    arn: String,
    creationTime: SyntheticTimestamp_date_time,
    durationInSeconds: Integer,
    errorDetails: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails
    ] = Optional.Absent,
    executionRoleArn: Optional[ExecutionRoleArn] = Optional.Absent,
    exportErrorDetails: Optional[
      zio.aws.sagemakergeospatial.model.ExportErrorDetails
    ] = Optional.Absent,
    exportStatus: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobExportStatus
    ] = Optional.Absent,
    inputConfig: zio.aws.sagemakergeospatial.model.InputConfigOutput,
    jobConfig: zio.aws.sagemakergeospatial.model.JobConfigInput,
    kmsKeyId: Optional[KmsKey] = Optional.Absent,
    name: String,
    outputBands: Optional[
      Iterable[zio.aws.sagemakergeospatial.model.OutputBand]
    ] = Optional.Absent,
    status: zio.aws.sagemakergeospatial.model.EarthObservationJobStatus,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobResponse = {
    import GetEarthObservationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobResponse
      .builder()
      .arn(arn: java.lang.String)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .durationInSeconds(durationInSeconds: java.lang.Integer)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .optionallyWith(
        executionRoleArn.map(value =>
          ExecutionRoleArn.unwrap(value): java.lang.String
        )
      )(_.executionRoleArn)
      .optionallyWith(exportErrorDetails.map(value => value.buildAwsValue()))(
        _.exportErrorDetails
      )
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .inputConfig(inputConfig.buildAwsValue())
      .jobConfig(jobConfig.buildAwsValue())
      .optionallyWith(
        kmsKeyId.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .name(name: java.lang.String)
      .optionallyWith(
        outputBands.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputBands)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse
      .wrap(buildAwsValue())
}
object GetEarthObservationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse =
      zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse(
        arn,
        creationTime,
        durationInSeconds,
        errorDetails.map(value => value.asEditable),
        executionRoleArn.map(value => value),
        exportErrorDetails.map(value => value.asEditable),
        exportStatus.map(value => value),
        inputConfig.asEditable,
        jobConfig.asEditable,
        kmsKeyId.map(value => value),
        name,
        outputBands.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status,
        tags.map(value => value)
      )
    def arn: String
    def creationTime: SyntheticTimestamp_date_time
    def durationInSeconds: Integer
    def errorDetails: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails.ReadOnly
    ]
    def executionRoleArn: Optional[ExecutionRoleArn]
    def exportErrorDetails: Optional[
      zio.aws.sagemakergeospatial.model.ExportErrorDetails.ReadOnly
    ]
    def exportStatus: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobExportStatus
    ]
    def inputConfig
        : zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly
    def jobConfig: zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly
    def kmsKeyId: Optional[KmsKey]
    def name: String
    def outputBands
        : Optional[List[zio.aws.sagemakergeospatial.model.OutputBand.ReadOnly]]
    def status: zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
    def tags: Optional[Map[String, String]]
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getDurationInSeconds: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(durationInSeconds)
    def getErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("errorDetails", errorDetails)
    def getExecutionRoleArn: ZIO[Any, AwsError, ExecutionRoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getExportErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ExportErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportErrorDetails", exportErrorDetails)
    def getExportStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.EarthObservationJobExportStatus
    ] = AwsError.unwrapOptionField("exportStatus", exportStatus)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly
    ] = ZIO.succeed(jobConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getOutputBands: ZIO[Any, AwsError, List[
      zio.aws.sagemakergeospatial.model.OutputBand.ReadOnly
    ]] = AwsError.unwrapOptionField("outputBands", outputBands)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
    ] = ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobResponse
  ) extends zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse.ReadOnly {
    override val arn: String = impl.arn(): String
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.sagemakergeospatial.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val durationInSeconds: Integer = impl.durationInSeconds(): Integer
    override val errorDetails: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errorDetails())
      .map(value =>
        zio.aws.sagemakergeospatial.model.EarthObservationJobErrorDetails
          .wrap(value)
      )
    override val executionRoleArn: Optional[ExecutionRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleArn())
        .map(value =>
          zio.aws.sagemakergeospatial.model.primitives.ExecutionRoleArn(value)
        )
    override val exportErrorDetails: Optional[
      zio.aws.sagemakergeospatial.model.ExportErrorDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportErrorDetails())
      .map(value =>
        zio.aws.sagemakergeospatial.model.ExportErrorDetails.wrap(value)
      )
    override val exportStatus: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobExportStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportStatus())
      .map(value =>
        zio.aws.sagemakergeospatial.model.EarthObservationJobExportStatus
          .wrap(value)
      )
    override val inputConfig
        : zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly =
      zio.aws.sagemakergeospatial.model.InputConfigOutput
        .wrap(impl.inputConfig())
    override val jobConfig
        : zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.JobConfigInput.wrap(impl.jobConfig())
    override val kmsKeyId: Optional[KmsKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemakergeospatial.model.primitives.KmsKey(value))
    override val name: String = impl.name(): String
    override val outputBands: Optional[
      List[zio.aws.sagemakergeospatial.model.OutputBand.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputBands())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakergeospatial.model.OutputBand.wrap(item)
        }.toList
      )
    override val status
        : zio.aws.sagemakergeospatial.model.EarthObservationJobStatus =
      zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
        .wrap(impl.status())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobResponse
  ): zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse.ReadOnly =
    new Wrapper(impl)
}
