package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ViewSunElevationInput(lowerBound: Float, upperBound: Float) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunElevationInput = {
    import ViewSunElevationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunElevationInput
      .builder()
      .lowerBound(lowerBound: java.lang.Float)
      .upperBound(upperBound: java.lang.Float)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ViewSunElevationInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.ViewSunElevationInput
      .wrap(buildAwsValue())
}
object ViewSunElevationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunElevationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.ViewSunElevationInput =
      zio.aws.sagemakergeospatial.model
        .ViewSunElevationInput(lowerBound, upperBound)
    def lowerBound: Float
    def upperBound: Float
    def getLowerBound: ZIO[Any, Nothing, Float] = ZIO.succeed(lowerBound)
    def getUpperBound: ZIO[Any, Nothing, Float] = ZIO.succeed(upperBound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunElevationInput
  ) extends zio.aws.sagemakergeospatial.model.ViewSunElevationInput.ReadOnly {
    override val lowerBound: Float = impl.lowerBound(): Float
    override val upperBound: Float = impl.upperBound(): Float
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunElevationInput
  ): zio.aws.sagemakergeospatial.model.ViewSunElevationInput.ReadOnly =
    new Wrapper(impl)
}
