package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.EarthObservationJobArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputConfigInput(
    dataSourceConfig: Optional[
      zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput
    ] = Optional.Absent,
    previousEarthObservationJobArn: Optional[EarthObservationJobArn] =
      Optional.Absent,
    rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigInput = {
    import InputConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigInput
      .builder()
      .optionallyWith(dataSourceConfig.map(value => value.buildAwsValue()))(
        _.dataSourceConfig
      )
      .optionallyWith(
        previousEarthObservationJobArn.map(value =>
          EarthObservationJobArn.unwrap(value): java.lang.String
        )
      )(_.previousEarthObservationJobArn)
      .optionallyWith(
        rasterDataCollectionQuery.map(value => value.buildAwsValue())
      )(_.rasterDataCollectionQuery)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.InputConfigInput.wrap(buildAwsValue())
}
object InputConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.InputConfigInput =
      zio.aws.sagemakergeospatial.model.InputConfigInput(
        dataSourceConfig.map(value => value.asEditable),
        previousEarthObservationJobArn.map(value => value),
        rasterDataCollectionQuery.map(value => value.asEditable)
      )
    def dataSourceConfig: Optional[
      zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.ReadOnly
    ]
    def previousEarthObservationJobArn: Optional[EarthObservationJobArn]
    def rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput.ReadOnly
    ]
    def getDataSourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("dataSourceConfig", dataSourceConfig)
    def getPreviousEarthObservationJobArn
        : ZIO[Any, AwsError, EarthObservationJobArn] =
      AwsError.unwrapOptionField(
        "previousEarthObservationJobArn",
        previousEarthObservationJobArn
      )
    def getRasterDataCollectionQuery: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rasterDataCollectionQuery",
      rasterDataCollectionQuery
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigInput
  ) extends zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly {
    override val dataSourceConfig: Optional[
      zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.wrap(value)
      )
    override val previousEarthObservationJobArn
        : Optional[EarthObservationJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.previousEarthObservationJobArn())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives
          .EarthObservationJobArn(value)
      )
    override val rasterDataCollectionQuery: Optional[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rasterDataCollectionQuery())
      .map(value =>
        zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigInput
  ): zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly = new Wrapper(
    impl
  )
}
