package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.{
  ExecutionRoleArn,
  SyntheticTimestamp_date_time,
  VectorEnrichmentJobArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ExportVectorEnrichmentJobResponse(
    arn: VectorEnrichmentJobArn,
    creationTime: SyntheticTimestamp_date_time,
    executionRoleArn: ExecutionRoleArn,
    exportStatus: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportStatus,
    outputConfig: zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse = {
    import ExportVectorEnrichmentJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse
      .builder()
      .arn(VectorEnrichmentJobArn.unwrap(arn): java.lang.String)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .executionRoleArn(
        ExecutionRoleArn.unwrap(executionRoleArn): java.lang.String
      )
      .exportStatus(exportStatus.unwrap)
      .outputConfig(outputConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse
      .wrap(buildAwsValue())
}
object ExportVectorEnrichmentJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse =
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse(
        arn,
        creationTime,
        executionRoleArn,
        exportStatus,
        outputConfig.asEditable
      )
    def arn: VectorEnrichmentJobArn
    def creationTime: SyntheticTimestamp_date_time
    def executionRoleArn: ExecutionRoleArn
    def exportStatus
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportStatus
    def outputConfig
        : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.ReadOnly
    def getArn: ZIO[Any, Nothing, VectorEnrichmentJobArn] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getExecutionRoleArn: ZIO[Any, Nothing, ExecutionRoleArn] =
      ZIO.succeed(executionRoleArn)
    def getExportStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportStatus
    ] = ZIO.succeed(exportStatus)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse
  ) extends zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse.ReadOnly {
    override val arn: VectorEnrichmentJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .VectorEnrichmentJobArn(impl.arn())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.sagemakergeospatial.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val executionRoleArn: ExecutionRoleArn =
      zio.aws.sagemakergeospatial.model.primitives
        .ExecutionRoleArn(impl.executionRoleArn())
    override val exportStatus
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportStatus =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportStatus
        .wrap(impl.exportStatus())
    override val outputConfig
        : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig
        .wrap(impl.outputConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse
  ): zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse.ReadOnly =
    new Wrapper(impl)
}
