package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Property(
    eoCloudCover: Optional[
      zio.aws.sagemakergeospatial.model.EoCloudCoverInput
    ] = Optional.Absent,
    landsatCloudCoverLand: Optional[
      zio.aws.sagemakergeospatial.model.LandsatCloudCoverLandInput
    ] = Optional.Absent,
    platform: Optional[zio.aws.sagemakergeospatial.model.PlatformInput] =
      Optional.Absent,
    viewOffNadir: Optional[
      zio.aws.sagemakergeospatial.model.ViewOffNadirInput
    ] = Optional.Absent,
    viewSunAzimuth: Optional[
      zio.aws.sagemakergeospatial.model.ViewSunAzimuthInput
    ] = Optional.Absent,
    viewSunElevation: Optional[
      zio.aws.sagemakergeospatial.model.ViewSunElevationInput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.Property = {
    import Property.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.Property
      .builder()
      .optionallyWith(eoCloudCover.map(value => value.buildAwsValue()))(
        _.eoCloudCover
      )
      .optionallyWith(
        landsatCloudCoverLand.map(value => value.buildAwsValue())
      )(_.landsatCloudCoverLand)
      .optionallyWith(platform.map(value => value.buildAwsValue()))(_.platform)
      .optionallyWith(viewOffNadir.map(value => value.buildAwsValue()))(
        _.viewOffNadir
      )
      .optionallyWith(viewSunAzimuth.map(value => value.buildAwsValue()))(
        _.viewSunAzimuth
      )
      .optionallyWith(viewSunElevation.map(value => value.buildAwsValue()))(
        _.viewSunElevation
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.Property.ReadOnly =
    zio.aws.sagemakergeospatial.model.Property.wrap(buildAwsValue())
}
object Property {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.Property
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.Property =
      zio.aws.sagemakergeospatial.model.Property(
        eoCloudCover.map(value => value.asEditable),
        landsatCloudCoverLand.map(value => value.asEditable),
        platform.map(value => value.asEditable),
        viewOffNadir.map(value => value.asEditable),
        viewSunAzimuth.map(value => value.asEditable),
        viewSunElevation.map(value => value.asEditable)
      )
    def eoCloudCover
        : Optional[zio.aws.sagemakergeospatial.model.EoCloudCoverInput.ReadOnly]
    def landsatCloudCoverLand: Optional[
      zio.aws.sagemakergeospatial.model.LandsatCloudCoverLandInput.ReadOnly
    ]
    def platform
        : Optional[zio.aws.sagemakergeospatial.model.PlatformInput.ReadOnly]
    def viewOffNadir
        : Optional[zio.aws.sagemakergeospatial.model.ViewOffNadirInput.ReadOnly]
    def viewSunAzimuth: Optional[
      zio.aws.sagemakergeospatial.model.ViewSunAzimuthInput.ReadOnly
    ]
    def viewSunElevation: Optional[
      zio.aws.sagemakergeospatial.model.ViewSunElevationInput.ReadOnly
    ]
    def getEoCloudCover: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.EoCloudCoverInput.ReadOnly
    ] = AwsError.unwrapOptionField("eoCloudCover", eoCloudCover)
    def getLandsatCloudCoverLand: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.LandsatCloudCoverLandInput.ReadOnly
    ] =
      AwsError.unwrapOptionField("landsatCloudCoverLand", landsatCloudCoverLand)
    def getPlatform: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.PlatformInput.ReadOnly
    ] = AwsError.unwrapOptionField("platform", platform)
    def getViewOffNadir: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ViewOffNadirInput.ReadOnly
    ] = AwsError.unwrapOptionField("viewOffNadir", viewOffNadir)
    def getViewSunAzimuth: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ViewSunAzimuthInput.ReadOnly
    ] = AwsError.unwrapOptionField("viewSunAzimuth", viewSunAzimuth)
    def getViewSunElevation: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ViewSunElevationInput.ReadOnly
    ] = AwsError.unwrapOptionField("viewSunElevation", viewSunElevation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.Property
  ) extends zio.aws.sagemakergeospatial.model.Property.ReadOnly {
    override val eoCloudCover: Optional[
      zio.aws.sagemakergeospatial.model.EoCloudCoverInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eoCloudCover())
      .map(value =>
        zio.aws.sagemakergeospatial.model.EoCloudCoverInput.wrap(value)
      )
    override val landsatCloudCoverLand: Optional[
      zio.aws.sagemakergeospatial.model.LandsatCloudCoverLandInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.landsatCloudCoverLand())
      .map(value =>
        zio.aws.sagemakergeospatial.model.LandsatCloudCoverLandInput.wrap(value)
      )
    override val platform
        : Optional[zio.aws.sagemakergeospatial.model.PlatformInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value =>
          zio.aws.sagemakergeospatial.model.PlatformInput.wrap(value)
        )
    override val viewOffNadir: Optional[
      zio.aws.sagemakergeospatial.model.ViewOffNadirInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.viewOffNadir())
      .map(value =>
        zio.aws.sagemakergeospatial.model.ViewOffNadirInput.wrap(value)
      )
    override val viewSunAzimuth: Optional[
      zio.aws.sagemakergeospatial.model.ViewSunAzimuthInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.viewSunAzimuth())
      .map(value =>
        zio.aws.sagemakergeospatial.model.ViewSunAzimuthInput.wrap(value)
      )
    override val viewSunElevation: Optional[
      zio.aws.sagemakergeospatial.model.ViewSunElevationInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.viewSunElevation())
      .map(value =>
        zio.aws.sagemakergeospatial.model.ViewSunElevationInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.Property
  ): zio.aws.sagemakergeospatial.model.Property.ReadOnly = new Wrapper(impl)
}
