package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssetValue(href: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.AssetValue = {
    import AssetValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.AssetValue
      .builder()
      .optionallyWith(href.map(value => value: java.lang.String))(_.href)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.AssetValue.ReadOnly =
    zio.aws.sagemakergeospatial.model.AssetValue.wrap(buildAwsValue())
}
object AssetValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.AssetValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.AssetValue =
      zio.aws.sagemakergeospatial.model.AssetValue(href.map(value => value))
    def href: Optional[String]
    def getHref: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("href", href)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.AssetValue
  ) extends zio.aws.sagemakergeospatial.model.AssetValue.ReadOnly {
    override val href: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.href())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.AssetValue
  ): zio.aws.sagemakergeospatial.model.AssetValue.ReadOnly = new Wrapper(impl)
}
