package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.VectorEnrichmentJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVectorEnrichmentJobRequest(arn: VectorEnrichmentJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest = {
    import DeleteVectorEnrichmentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest
      .builder()
      .arn(VectorEnrichmentJobArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest
      .wrap(buildAwsValue())
}
object DeleteVectorEnrichmentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest =
      zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest(arn)
    def arn: VectorEnrichmentJobArn
    def getArn: ZIO[Any, Nothing, VectorEnrichmentJobArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest
  ) extends zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest.ReadOnly {
    override val arn: VectorEnrichmentJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .VectorEnrichmentJobArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest
  ): zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest.ReadOnly =
    new Wrapper(impl)
}
