package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.{
  NextToken,
  DataCollectionArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchRasterDataCollectionRequest(
    arn: DataCollectionArn,
    nextToken: Optional[NextToken] = Optional.Absent,
    rasterDataCollectionQuery: zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest = {
    import SearchRasterDataCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest
      .builder()
      .arn(DataCollectionArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .rasterDataCollectionQuery(rasterDataCollectionQuery.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionRequest
      .wrap(buildAwsValue())
}
object SearchRasterDataCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionRequest =
      zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionRequest(
        arn,
        nextToken.map(value => value),
        rasterDataCollectionQuery.asEditable
      )
    def arn: DataCollectionArn
    def nextToken: Optional[NextToken]
    def rasterDataCollectionQuery
        : zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput.ReadOnly
    def getArn: ZIO[Any, Nothing, DataCollectionArn] = ZIO.succeed(arn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRasterDataCollectionQuery: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput.ReadOnly
    ] = ZIO.succeed(rasterDataCollectionQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest
  ) extends zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionRequest.ReadOnly {
    override val arn: DataCollectionArn =
      zio.aws.sagemakergeospatial.model.primitives.DataCollectionArn(impl.arn())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives.NextToken(value)
      )
    override val rasterDataCollectionQuery
        : zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput
        .wrap(impl.rasterDataCollectionQuery())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest
  ): zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
