package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Properties(
    eoCloudCover: Optional[Float] = Optional.Absent,
    landsatCloudCoverLand: Optional[Float] = Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    viewOffNadir: Optional[Float] = Optional.Absent,
    viewSunAzimuth: Optional[Float] = Optional.Absent,
    viewSunElevation: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.Properties = {
    import Properties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.Properties
      .builder()
      .optionallyWith(eoCloudCover.map(value => value: java.lang.Float))(
        _.eoCloudCover
      )
      .optionallyWith(
        landsatCloudCoverLand.map(value => value: java.lang.Float)
      )(_.landsatCloudCoverLand)
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(viewOffNadir.map(value => value: java.lang.Float))(
        _.viewOffNadir
      )
      .optionallyWith(viewSunAzimuth.map(value => value: java.lang.Float))(
        _.viewSunAzimuth
      )
      .optionallyWith(viewSunElevation.map(value => value: java.lang.Float))(
        _.viewSunElevation
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.Properties.ReadOnly =
    zio.aws.sagemakergeospatial.model.Properties.wrap(buildAwsValue())
}
object Properties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.Properties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.Properties =
      zio.aws.sagemakergeospatial.model.Properties(
        eoCloudCover.map(value => value),
        landsatCloudCoverLand.map(value => value),
        platform.map(value => value),
        viewOffNadir.map(value => value),
        viewSunAzimuth.map(value => value),
        viewSunElevation.map(value => value)
      )
    def eoCloudCover: Optional[Float]
    def landsatCloudCoverLand: Optional[Float]
    def platform: Optional[String]
    def viewOffNadir: Optional[Float]
    def viewSunAzimuth: Optional[Float]
    def viewSunElevation: Optional[Float]
    def getEoCloudCover: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("eoCloudCover", eoCloudCover)
    def getLandsatCloudCoverLand: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("landsatCloudCoverLand", landsatCloudCoverLand)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getViewOffNadir: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("viewOffNadir", viewOffNadir)
    def getViewSunAzimuth: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("viewSunAzimuth", viewSunAzimuth)
    def getViewSunElevation: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("viewSunElevation", viewSunElevation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.Properties
  ) extends zio.aws.sagemakergeospatial.model.Properties.ReadOnly {
    override val eoCloudCover: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.eoCloudCover())
      .map(value => value: Float)
    override val landsatCloudCoverLand: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.landsatCloudCoverLand())
      .map(value => value: Float)
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val viewOffNadir: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.viewOffNadir())
      .map(value => value: Float)
    override val viewSunAzimuth: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.viewSunAzimuth())
      .map(value => value: Float)
    override val viewSunElevation: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.viewSunElevation())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.Properties
  ): zio.aws.sagemakergeospatial.model.Properties.ReadOnly = new Wrapper(impl)
}
