package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.DataCollectionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RasterDataCollectionQueryInput(
    areaOfInterest: Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest] =
      Optional.Absent,
    propertyFilters: Optional[
      zio.aws.sagemakergeospatial.model.PropertyFilters
    ] = Optional.Absent,
    rasterDataCollectionArn: DataCollectionArn,
    timeRangeFilter: zio.aws.sagemakergeospatial.model.TimeRangeFilterInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryInput = {
    import RasterDataCollectionQueryInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryInput
      .builder()
      .optionallyWith(areaOfInterest.map(value => value.buildAwsValue()))(
        _.areaOfInterest
      )
      .optionallyWith(propertyFilters.map(value => value.buildAwsValue()))(
        _.propertyFilters
      )
      .rasterDataCollectionArn(
        DataCollectionArn.unwrap(rasterDataCollectionArn): java.lang.String
      )
      .timeRangeFilter(timeRangeFilter.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput
      .wrap(buildAwsValue())
}
object RasterDataCollectionQueryInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput =
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput(
        areaOfInterest.map(value => value.asEditable),
        propertyFilters.map(value => value.asEditable),
        rasterDataCollectionArn,
        timeRangeFilter.asEditable
      )
    def areaOfInterest
        : Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly]
    def propertyFilters
        : Optional[zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly]
    def rasterDataCollectionArn: DataCollectionArn
    def timeRangeFilter
        : zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly
    def getAreaOfInterest: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly
    ] = AwsError.unwrapOptionField("areaOfInterest", areaOfInterest)
    def getPropertyFilters: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly
    ] = AwsError.unwrapOptionField("propertyFilters", propertyFilters)
    def getRasterDataCollectionArn: ZIO[Any, Nothing, DataCollectionArn] =
      ZIO.succeed(rasterDataCollectionArn)
    def getTimeRangeFilter: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly
    ] = ZIO.succeed(timeRangeFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryInput
  ) extends zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput.ReadOnly {
    override val areaOfInterest
        : Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.areaOfInterest())
        .map(value =>
          zio.aws.sagemakergeospatial.model.AreaOfInterest.wrap(value)
        )
    override val propertyFilters
        : Optional[zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyFilters())
        .map(value =>
          zio.aws.sagemakergeospatial.model.PropertyFilters.wrap(value)
        )
    override val rasterDataCollectionArn: DataCollectionArn =
      zio.aws.sagemakergeospatial.model.primitives
        .DataCollectionArn(impl.rasterDataCollectionArn())
    override val timeRangeFilter
        : zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.TimeRangeFilterInput
        .wrap(impl.timeRangeFilter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryInput
  ): zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryInput.ReadOnly =
    new Wrapper(impl)
}
