package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVectorEnrichmentJobsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    vectorEnrichmentJobSummaries: Iterable[
      zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse = {
    import ListVectorEnrichmentJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .vectorEnrichmentJobSummaries(vectorEnrichmentJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse
      .wrap(buildAwsValue())
}
object ListVectorEnrichmentJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse =
      zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse(
        nextToken.map(value => value),
        vectorEnrichmentJobSummaries.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def vectorEnrichmentJobSummaries: List[
      zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVectorEnrichmentJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly
    ]] = ZIO.succeed(vectorEnrichmentJobSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse
  ) extends zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives.NextToken(value)
      )
    override val vectorEnrichmentJobSummaries: List[
      zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly
    ] = impl
      .vectorEnrichmentJobSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse
  ): zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse.ReadOnly =
    new Wrapper(impl)
}
