package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEarthObservationJobsResponse(
    earthObservationJobSummaries: Iterable[
      zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse = {
    import ListEarthObservationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse
      .builder()
      .earthObservationJobSummaries(earthObservationJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse
      .wrap(buildAwsValue())
}
object ListEarthObservationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse =
      zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse(
        earthObservationJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def earthObservationJobSummaries: List[
      zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getEarthObservationJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly
    ]] = ZIO.succeed(earthObservationJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse
  ) extends zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse.ReadOnly {
    override val earthObservationJobSummaries: List[
      zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly
    ] = impl
      .earthObservationJobSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig
          .wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse
  ): zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse.ReadOnly =
    new Wrapper(impl)
}
