package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LandsatCloudCoverLandInput(
    lowerBound: Float,
    upperBound: Float
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.LandsatCloudCoverLandInput = {
    import LandsatCloudCoverLandInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.LandsatCloudCoverLandInput
      .builder()
      .lowerBound(lowerBound: java.lang.Float)
      .upperBound(upperBound: java.lang.Float)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.LandsatCloudCoverLandInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.LandsatCloudCoverLandInput
      .wrap(buildAwsValue())
}
object LandsatCloudCoverLandInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.LandsatCloudCoverLandInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.LandsatCloudCoverLandInput =
      zio.aws.sagemakergeospatial.model
        .LandsatCloudCoverLandInput(lowerBound, upperBound)
    def lowerBound: Float
    def upperBound: Float
    def getLowerBound: ZIO[Any, Nothing, Float] = ZIO.succeed(lowerBound)
    def getUpperBound: ZIO[Any, Nothing, Float] = ZIO.succeed(upperBound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.LandsatCloudCoverLandInput
  ) extends zio.aws.sagemakergeospatial.model.LandsatCloudCoverLandInput.ReadOnly {
    override val lowerBound: Float = impl.lowerBound(): Float
    override val upperBound: Float = impl.upperBound(): Float
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.LandsatCloudCoverLandInput
  ): zio.aws.sagemakergeospatial.model.LandsatCloudCoverLandInput.ReadOnly =
    new Wrapper(impl)
}
