package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.EarthObservationJobArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportEarthObservationJobRequest(
    arn: EarthObservationJobArn,
    executionRoleArn: String,
    exportSourceImages: Optional[Boolean] = Optional.Absent,
    outputConfig: zio.aws.sagemakergeospatial.model.OutputConfigInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobRequest = {
    import ExportEarthObservationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobRequest
      .builder()
      .arn(EarthObservationJobArn.unwrap(arn): java.lang.String)
      .executionRoleArn(executionRoleArn: java.lang.String)
      .optionallyWith(
        exportSourceImages.map(value => value: java.lang.Boolean)
      )(_.exportSourceImages)
      .outputConfig(outputConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ExportEarthObservationJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.ExportEarthObservationJobRequest
      .wrap(buildAwsValue())
}
object ExportEarthObservationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ExportEarthObservationJobRequest =
      zio.aws.sagemakergeospatial.model.ExportEarthObservationJobRequest(
        arn,
        executionRoleArn,
        exportSourceImages.map(value => value),
        outputConfig.asEditable
      )
    def arn: EarthObservationJobArn
    def executionRoleArn: String
    def exportSourceImages: Optional[Boolean]
    def outputConfig
        : zio.aws.sagemakergeospatial.model.OutputConfigInput.ReadOnly
    def getArn: ZIO[Any, Nothing, EarthObservationJobArn] = ZIO.succeed(arn)
    def getExecutionRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(executionRoleArn)
    def getExportSourceImages: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("exportSourceImages", exportSourceImages)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.OutputConfigInput.ReadOnly
    ] = ZIO.succeed(outputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobRequest
  ) extends zio.aws.sagemakergeospatial.model.ExportEarthObservationJobRequest.ReadOnly {
    override val arn: EarthObservationJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .EarthObservationJobArn(impl.arn())
    override val executionRoleArn: String = impl.executionRoleArn(): String
    override val exportSourceImages: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.exportSourceImages())
      .map(value => value: Boolean)
    override val outputConfig
        : zio.aws.sagemakergeospatial.model.OutputConfigInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.OutputConfigInput
        .wrap(impl.outputConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobRequest
  ): zio.aws.sagemakergeospatial.model.ExportEarthObservationJobRequest.ReadOnly =
    new Wrapper(impl)
}
