package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EojDataSourceConfigInput(
    s3Data: Optional[zio.aws.sagemakergeospatial.model.S3DataInput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.EojDataSourceConfigInput = {
    import EojDataSourceConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.EojDataSourceConfigInput
      .builder()
      .optionallyWith(s3Data.map(value => value.buildAwsValue()))(_.s3Data)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput
      .wrap(buildAwsValue())
}
object EojDataSourceConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.EojDataSourceConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput =
      zio.aws.sagemakergeospatial.model
        .EojDataSourceConfigInput(s3Data.map(value => value.asEditable))
    def s3Data: Optional[zio.aws.sagemakergeospatial.model.S3DataInput.ReadOnly]
    def getS3Data: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.S3DataInput.ReadOnly
    ] = AwsError.unwrapOptionField("s3Data", s3Data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.EojDataSourceConfigInput
  ) extends zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.ReadOnly {
    override val s3Data
        : Optional[zio.aws.sagemakergeospatial.model.S3DataInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Data())
        .map(value => zio.aws.sagemakergeospatial.model.S3DataInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.EojDataSourceConfigInput
  ): zio.aws.sagemakergeospatial.model.EojDataSourceConfigInput.ReadOnly =
    new Wrapper(impl)
}
