package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputResolutionStackInput(
    predefined: Optional[
      zio.aws.sagemakergeospatial.model.PredefinedResolution
    ] = Optional.Absent,
    userDefined: Optional[zio.aws.sagemakergeospatial.model.UserDefined] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.OutputResolutionStackInput = {
    import OutputResolutionStackInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.OutputResolutionStackInput
      .builder()
      .optionallyWith(predefined.map(value => value.unwrap))(_.predefined)
      .optionallyWith(userDefined.map(value => value.buildAwsValue()))(
        _.userDefined
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.OutputResolutionStackInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.OutputResolutionStackInput
      .wrap(buildAwsValue())
}
object OutputResolutionStackInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.OutputResolutionStackInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.OutputResolutionStackInput =
      zio.aws.sagemakergeospatial.model.OutputResolutionStackInput(
        predefined.map(value => value),
        userDefined.map(value => value.asEditable)
      )
    def predefined
        : Optional[zio.aws.sagemakergeospatial.model.PredefinedResolution]
    def userDefined
        : Optional[zio.aws.sagemakergeospatial.model.UserDefined.ReadOnly]
    def getPredefined: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.PredefinedResolution
    ] = AwsError.unwrapOptionField("predefined", predefined)
    def getUserDefined: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.UserDefined.ReadOnly
    ] = AwsError.unwrapOptionField("userDefined", userDefined)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.OutputResolutionStackInput
  ) extends zio.aws.sagemakergeospatial.model.OutputResolutionStackInput.ReadOnly {
    override val predefined
        : Optional[zio.aws.sagemakergeospatial.model.PredefinedResolution] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predefined())
        .map(value =>
          zio.aws.sagemakergeospatial.model.PredefinedResolution.wrap(value)
        )
    override val userDefined
        : Optional[zio.aws.sagemakergeospatial.model.UserDefined.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userDefined())
        .map(value => zio.aws.sagemakergeospatial.model.UserDefined.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.OutputResolutionStackInput
  ): zio.aws.sagemakergeospatial.model.OutputResolutionStackInput.ReadOnly =
    new Wrapper(impl)
}
