package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ListTagsForResourceRequest =
      zio.aws.sagemakergeospatial.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListTagsForResourceRequest
  ) extends zio.aws.sagemakergeospatial.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.sagemakergeospatial.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListTagsForResourceRequest
  ): zio.aws.sagemakergeospatial.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
