package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Filter(
    maximum: Optional[Float] = Optional.Absent,
    minimum: Optional[Float] = Optional.Absent,
    name: String,
    `type`: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.Filter
      .builder()
      .optionallyWith(maximum.map(value => value: java.lang.Float))(_.maximum)
      .optionallyWith(minimum.map(value => value: java.lang.Float))(_.minimum)
      .name(name: java.lang.String)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.Filter.ReadOnly =
    zio.aws.sagemakergeospatial.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.Filter =
      zio.aws.sagemakergeospatial.model.Filter(
        maximum.map(value => value),
        minimum.map(value => value),
        name,
        `type`
      )
    def maximum: Optional[Float]
    def minimum: Optional[Float]
    def name: String
    def `type`: String
    def getMaximum: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getMinimum: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.Filter
  ) extends zio.aws.sagemakergeospatial.model.Filter.ReadOnly {
    override val maximum: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.maximum())
      .map(value => value: Float)
    override val minimum: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.minimum())
      .map(value => value: Float)
    override val name: String = impl.name(): String
    override val `type`: String = impl.`type`(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.Filter
  ): zio.aws.sagemakergeospatial.model.Filter.ReadOnly = new Wrapper(impl)
}
