package zio.aws.sagemakergeospatial.model
import scala.jdk.CollectionConverters._
sealed trait ZonalStatistics {
  def unwrap: software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics
}
object ZonalStatistics {
  def wrap(
      value: software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics
  ): zio.aws.sagemakergeospatial.model.ZonalStatistics = value match {
    case software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.MEAN =>
      val r = MEAN
      r
    case software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.MEDIAN =>
      val r = MEDIAN
      r
    case software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.STANDARD_DEVIATION =>
      val r = STANDARD_DEVIATION
      r
    case software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.MAX =>
      val r = MAX
      r
    case software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.MIN =>
      val r = MIN
      r
    case software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.SUM =>
      val r = SUM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemakergeospatial.model.ZonalStatistics {
    override def unwrap
        : software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics =
      software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.UNKNOWN_TO_SDK_VERSION
  }
  case object MEAN extends zio.aws.sagemakergeospatial.model.ZonalStatistics {
    override def unwrap
        : software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics =
      software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.MEAN
  }
  case object MEDIAN extends zio.aws.sagemakergeospatial.model.ZonalStatistics {
    override def unwrap
        : software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics =
      software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.MEDIAN
  }
  case object STANDARD_DEVIATION
      extends zio.aws.sagemakergeospatial.model.ZonalStatistics {
    override def unwrap
        : software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics =
      software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.STANDARD_DEVIATION
  }
  case object MAX extends zio.aws.sagemakergeospatial.model.ZonalStatistics {
    override def unwrap
        : software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics =
      software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.MAX
  }
  case object MIN extends zio.aws.sagemakergeospatial.model.ZonalStatistics {
    override def unwrap
        : software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics =
      software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.MIN
  }
  case object SUM extends zio.aws.sagemakergeospatial.model.ZonalStatistics {
    override def unwrap
        : software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics =
      software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatistics.SUM
  }
}
