package zio.aws.sagemakergeospatial.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.{
  NextToken,
  ListRasterDataCollectionsInputMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRasterDataCollectionsRequest(
    maxResults: Optional[ListRasterDataCollectionsInputMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest = {
    import ListRasterDataCollectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListRasterDataCollectionsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsRequest
      .wrap(buildAwsValue())
}
object ListRasterDataCollectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsRequest =
      zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListRasterDataCollectionsInputMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def getMaxResults
        : ZIO[Any, AwsError, ListRasterDataCollectionsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest
  ) extends zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsRequest.ReadOnly {
    override val maxResults
        : Optional[ListRasterDataCollectionsInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.sagemakergeospatial.model.primitives
            .ListRasterDataCollectionsInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest
  ): zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsRequest.ReadOnly =
    new Wrapper(impl)
}
