package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.{
  Integer,
  EarthObservationJobArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTileRequest(
    arn: EarthObservationJobArn,
    imageAssets: Iterable[String],
    imageMask: Optional[Boolean] = Optional.Absent,
    outputDataType: Optional[zio.aws.sagemakergeospatial.model.OutputType] =
      Optional.Absent,
    outputFormat: Optional[String] = Optional.Absent,
    propertyFilters: Optional[String] = Optional.Absent,
    target: zio.aws.sagemakergeospatial.model.TargetOptions,
    timeRangeFilter: Optional[String] = Optional.Absent,
    x: Integer,
    y: Integer,
    z: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.GetTileRequest = {
    import GetTileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.GetTileRequest
      .builder()
      .arn(EarthObservationJobArn.unwrap(arn): java.lang.String)
      .imageAssets(imageAssets.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(imageMask.map(value => value: java.lang.Boolean))(
        _.imageMask
      )
      .optionallyWith(outputDataType.map(value => value.unwrap))(
        _.outputDataType
      )
      .optionallyWith(outputFormat.map(value => value: java.lang.String))(
        _.outputFormat
      )
      .optionallyWith(propertyFilters.map(value => value: java.lang.String))(
        _.propertyFilters
      )
      .target(target.unwrap)
      .optionallyWith(timeRangeFilter.map(value => value: java.lang.String))(
        _.timeRangeFilter
      )
      .x(x: java.lang.Integer)
      .y(y: java.lang.Integer)
      .z(z: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.GetTileRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.GetTileRequest.wrap(buildAwsValue())
}
object GetTileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.GetTileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.GetTileRequest =
      zio.aws.sagemakergeospatial.model.GetTileRequest(
        arn,
        imageAssets,
        imageMask.map(value => value),
        outputDataType.map(value => value),
        outputFormat.map(value => value),
        propertyFilters.map(value => value),
        target,
        timeRangeFilter.map(value => value),
        x,
        y,
        z
      )
    def arn: EarthObservationJobArn
    def imageAssets: List[String]
    def imageMask: Optional[Boolean]
    def outputDataType: Optional[zio.aws.sagemakergeospatial.model.OutputType]
    def outputFormat: Optional[String]
    def propertyFilters: Optional[String]
    def target: zio.aws.sagemakergeospatial.model.TargetOptions
    def timeRangeFilter: Optional[String]
    def x: Integer
    def y: Integer
    def z: Integer
    def getArn: ZIO[Any, Nothing, EarthObservationJobArn] = ZIO.succeed(arn)
    def getImageAssets: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(imageAssets)
    def getImageMask: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("imageMask", imageMask)
    def getOutputDataType
        : ZIO[Any, AwsError, zio.aws.sagemakergeospatial.model.OutputType] =
      AwsError.unwrapOptionField("outputDataType", outputDataType)
    def getOutputFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outputFormat", outputFormat)
    def getPropertyFilters: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("propertyFilters", propertyFilters)
    def getTarget
        : ZIO[Any, Nothing, zio.aws.sagemakergeospatial.model.TargetOptions] =
      ZIO.succeed(target)
    def getTimeRangeFilter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timeRangeFilter", timeRangeFilter)
    def getX: ZIO[Any, Nothing, Integer] = ZIO.succeed(x)
    def getY: ZIO[Any, Nothing, Integer] = ZIO.succeed(y)
    def getZ: ZIO[Any, Nothing, Integer] = ZIO.succeed(z)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetTileRequest
  ) extends zio.aws.sagemakergeospatial.model.GetTileRequest.ReadOnly {
    override val arn: EarthObservationJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .EarthObservationJobArn(impl.arn())
    override val imageAssets: List[String] = impl
      .imageAssets()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val imageMask: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.imageMask())
      .map(value => value: Boolean)
    override val outputDataType
        : Optional[zio.aws.sagemakergeospatial.model.OutputType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputDataType())
        .map(value => zio.aws.sagemakergeospatial.model.OutputType.wrap(value))
    override val outputFormat: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outputFormat())
      .map(value => value: String)
    override val propertyFilters: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyFilters())
      .map(value => value: String)
    override val target: zio.aws.sagemakergeospatial.model.TargetOptions =
      zio.aws.sagemakergeospatial.model.TargetOptions.wrap(impl.target())
    override val timeRangeFilter: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timeRangeFilter())
      .map(value => value: String)
    override val x: Integer = impl.x(): Integer
    override val y: Integer = impl.y(): Integer
    override val z: Integer = impl.z(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetTileRequest
  ): zio.aws.sagemakergeospatial.model.GetTileRequest.ReadOnly = new Wrapper(
    impl
  )
}
