package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportErrorDetails(
    exportResults: Optional[
      zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput
    ] = Optional.Absent,
    exportSourceImages: Optional[
      zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetails = {
    import ExportErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetails
      .builder()
      .optionallyWith(exportResults.map(value => value.buildAwsValue()))(
        _.exportResults
      )
      .optionallyWith(exportSourceImages.map(value => value.buildAwsValue()))(
        _.exportSourceImages
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ExportErrorDetails.ReadOnly =
    zio.aws.sagemakergeospatial.model.ExportErrorDetails.wrap(buildAwsValue())
}
object ExportErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.ExportErrorDetails =
      zio.aws.sagemakergeospatial.model.ExportErrorDetails(
        exportResults.map(value => value.asEditable),
        exportSourceImages.map(value => value.asEditable)
      )
    def exportResults: Optional[
      zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.ReadOnly
    ]
    def exportSourceImages: Optional[
      zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.ReadOnly
    ]
    def getExportResults: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.ReadOnly
    ] = AwsError.unwrapOptionField("exportResults", exportResults)
    def getExportSourceImages: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.ReadOnly
    ] = AwsError.unwrapOptionField("exportSourceImages", exportSourceImages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetails
  ) extends zio.aws.sagemakergeospatial.model.ExportErrorDetails.ReadOnly {
    override val exportResults: Optional[
      zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportResults())
      .map(value =>
        zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.wrap(value)
      )
    override val exportSourceImages: Optional[
      zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportSourceImages())
      .map(value =>
        zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetails
  ): zio.aws.sagemakergeospatial.model.ExportErrorDetails.ReadOnly =
    new Wrapper(impl)
}
