package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Map[String, String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.TagResourceRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.TagResourceRequest =
      zio.aws.sagemakergeospatial.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: Arn
    def tags: Map[String, String]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[String, String]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.TagResourceRequest
  ) extends zio.aws.sagemakergeospatial.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.sagemakergeospatial.model.primitives.Arn(impl.resourceArn())
    override val tags: Map[String, String] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.TagResourceRequest
  ): zio.aws.sagemakergeospatial.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
