package zio.aws.sagemakergeospatial.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.{
  NextToken,
  ListEarthObservationJobInputMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEarthObservationJobsRequest(
    maxResults: Optional[ListEarthObservationJobInputMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sortBy: Optional[String] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemakergeospatial.model.SortOrder] =
      Optional.Absent,
    statusEquals: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest = {
    import ListEarthObservationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListEarthObservationJobInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value: java.lang.String))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ListEarthObservationJobsRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.ListEarthObservationJobsRequest
      .wrap(buildAwsValue())
}
object ListEarthObservationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ListEarthObservationJobsRequest =
      zio.aws.sagemakergeospatial.model.ListEarthObservationJobsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        statusEquals.map(value => value)
      )
    def maxResults: Optional[ListEarthObservationJobInputMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def sortBy: Optional[String]
    def sortOrder: Optional[zio.aws.sagemakergeospatial.model.SortOrder]
    def statusEquals
        : Optional[zio.aws.sagemakergeospatial.model.EarthObservationJobStatus]
    def getMaxResults
        : ZIO[Any, AwsError, ListEarthObservationJobInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemakergeospatial.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getStatusEquals: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
    ] = AwsError.unwrapOptionField("statusEquals", statusEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest
  ) extends zio.aws.sagemakergeospatial.model.ListEarthObservationJobsRequest.ReadOnly {
    override val maxResults
        : Optional[ListEarthObservationJobInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.sagemakergeospatial.model.primitives
            .ListEarthObservationJobInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives.NextToken(value)
      )
    override val sortBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value => value: String)
    override val sortOrder
        : Optional[zio.aws.sagemakergeospatial.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemakergeospatial.model.SortOrder.wrap(value))
    override val statusEquals: Optional[
      zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statusEquals())
      .map(value =>
        zio.aws.sagemakergeospatial.model.EarthObservationJobStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest
  ): zio.aws.sagemakergeospatial.model.ListEarthObservationJobsRequest.ReadOnly =
    new Wrapper(impl)
}
