package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.ExpiresAt
import scala.jdk.CollectionConverters.*
final case class GetRecordResponse(
    record: Optional[
      Iterable[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue]
    ] = Optional.Absent,
    expiresAt: Optional[ExpiresAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse = {
    import GetRecordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse
      .builder()
      .optionallyWith(
        record.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.record)
      .optionallyWith(
        expiresAt.map(value => ExpiresAt.unwrap(value): java.lang.String)
      )(_.expiresAt)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse
      .wrap(buildAwsValue())
}
object GetRecordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse =
      zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse(
        record.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        expiresAt.map(value => value)
      )
    def record: Optional[
      List[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly]
    ]
    def expiresAt: Optional[ExpiresAt]
    def getRecord: ZIO[Any, AwsError, List[
      zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly
    ]] = AwsError.unwrapOptionField("record", record)
    def getExpiresAt: ZIO[Any, AwsError, ExpiresAt] =
      AwsError.unwrapOptionField("expiresAt", expiresAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse.ReadOnly {
    override val record: Optional[
      List[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.record())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.wrap(item)
        }.toList
      )
    override val expiresAt: Optional[ExpiresAt] = zio.aws.core.internal
      .optionalFromNullable(impl.expiresAt())
      .map(value =>
        zio.aws.sagemakerfeaturestoreruntime.model.primitives.ExpiresAt(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordResponse
  ): zio.aws.sagemakerfeaturestoreruntime.model.GetRecordResponse.ReadOnly =
    new Wrapper(impl)
}
