package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.{
  ValueAsString,
  FeatureName
}
import scala.jdk.CollectionConverters.*
final case class FeatureValue(
    featureName: FeatureName,
    valueAsString: Optional[ValueAsString] = Optional.Absent,
    valueAsStringList: Optional[Iterable[ValueAsString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue = {
    import FeatureValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue
      .builder()
      .featureName(FeatureName.unwrap(featureName): java.lang.String)
      .optionallyWith(
        valueAsString.map(value =>
          ValueAsString.unwrap(value): java.lang.String
        )
      )(_.valueAsString)
      .optionallyWith(
        valueAsStringList.map(value =>
          value.map { item =>
            ValueAsString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.valueAsStringList)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue
      .wrap(buildAwsValue())
}
object FeatureValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue =
      zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue(
        featureName,
        valueAsString.map(value => value),
        valueAsStringList.map(value => value)
      )
    def featureName: FeatureName
    def valueAsString: Optional[ValueAsString]
    def valueAsStringList: Optional[List[ValueAsString]]
    def getFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(featureName)
    def getValueAsString: ZIO[Any, AwsError, ValueAsString] =
      AwsError.unwrapOptionField("valueAsString", valueAsString)
    def getValueAsStringList: ZIO[Any, AwsError, List[ValueAsString]] =
      AwsError.unwrapOptionField("valueAsStringList", valueAsStringList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly {
    override val featureName: FeatureName =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .FeatureName(impl.featureName())
    override val valueAsString: Optional[ValueAsString] = zio.aws.core.internal
      .optionalFromNullable(impl.valueAsString())
      .map(value =>
        zio.aws.sagemakerfeaturestoreruntime.model.primitives
          .ValueAsString(value)
      )
    override val valueAsStringList: Optional[List[ValueAsString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.valueAsStringList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemakerfeaturestoreruntime.model.primitives
              .ValueAsString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureValue
  ): zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly =
    new Wrapper(impl)
}
