package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.{
  FeatureName,
  ValueAsString,
  FeatureGroupNameOrArn
}
import scala.jdk.CollectionConverters.*
final case class GetRecordRequest(
    featureGroupName: FeatureGroupNameOrArn,
    recordIdentifierValueAsString: ValueAsString,
    featureNames: Optional[Iterable[FeatureName]] = Optional.Absent,
    expirationTimeResponse: Optional[
      zio.aws.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest = {
    import GetRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest
      .builder()
      .featureGroupName(
        FeatureGroupNameOrArn.unwrap(featureGroupName): java.lang.String
      )
      .recordIdentifierValueAsString(
        ValueAsString.unwrap(recordIdentifierValueAsString): java.lang.String
      )
      .optionallyWith(
        featureNames.map(value =>
          value.map { item =>
            FeatureName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.featureNames)
      .optionallyWith(expirationTimeResponse.map(value => value.unwrap))(
        _.expirationTimeResponse
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest
      .wrap(buildAwsValue())
}
object GetRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest =
      zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest(
        featureGroupName,
        recordIdentifierValueAsString,
        featureNames.map(value => value),
        expirationTimeResponse.map(value => value)
      )
    def featureGroupName: FeatureGroupNameOrArn
    def recordIdentifierValueAsString: ValueAsString
    def featureNames: Optional[List[FeatureName]]
    def expirationTimeResponse: Optional[
      zio.aws.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse
    ]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupNameOrArn] =
      ZIO.succeed(featureGroupName)
    def getRecordIdentifierValueAsString: ZIO[Any, Nothing, ValueAsString] =
      ZIO.succeed(recordIdentifierValueAsString)
    def getFeatureNames: ZIO[Any, AwsError, List[FeatureName]] =
      AwsError.unwrapOptionField("featureNames", featureNames)
    def getExpirationTimeResponse: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse
    ] = AwsError.unwrapOptionField(
      "expirationTimeResponse",
      expirationTimeResponse
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest.ReadOnly {
    override val featureGroupName: FeatureGroupNameOrArn =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .FeatureGroupNameOrArn(impl.featureGroupName())
    override val recordIdentifierValueAsString: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.recordIdentifierValueAsString())
    override val featureNames: Optional[List[FeatureName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemakerfeaturestoreruntime.model.primitives
              .FeatureName(item)
          }.toList
        )
    override val expirationTimeResponse: Optional[
      zio.aws.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationTimeResponse())
      .map(value =>
        zio.aws.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.GetRecordRequest
  ): zio.aws.sagemakerfeaturestoreruntime.model.GetRecordRequest.ReadOnly =
    new Wrapper(impl)
}
