package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.FeatureGroupName
import scala.jdk.CollectionConverters.*
final case class PutRecordRequest(
    featureGroupName: FeatureGroupName,
    record: Iterable[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue],
    targetStores: Optional[
      Iterable[zio.aws.sagemakerfeaturestoreruntime.model.TargetStore]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest = {
    import PutRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest
      .builder()
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .record(record.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        targetStores.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.targetStoresWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest
      .wrap(buildAwsValue())
}
object PutRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest =
      zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest(
        featureGroupName,
        record.map { item =>
          item.asEditable
        },
        targetStores.map(value => value)
      )
    def featureGroupName: FeatureGroupName
    def record
        : List[zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly]
    def targetStores
        : Optional[List[zio.aws.sagemakerfeaturestoreruntime.model.TargetStore]]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getRecord: ZIO[Any, Nothing, List[
      zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly
    ]] = ZIO.succeed(record)
    def getTargetStores: ZIO[Any, AwsError, List[
      zio.aws.sagemakerfeaturestoreruntime.model.TargetStore
    ]] = AwsError.unwrapOptionField("targetStores", targetStores)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest.ReadOnly {
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val record: List[
      zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.ReadOnly
    ] = impl
      .record()
      .asScala
      .map { item =>
        zio.aws.sagemakerfeaturestoreruntime.model.FeatureValue.wrap(item)
      }
      .toList
    override val targetStores: Optional[
      List[zio.aws.sagemakerfeaturestoreruntime.model.TargetStore]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetStores())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakerfeaturestoreruntime.model.TargetStore.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.PutRecordRequest
  ): zio.aws.sagemakerfeaturestoreruntime.model.PutRecordRequest.ReadOnly =
    new Wrapper(impl)
}
