package zio.aws.sagemakerfeaturestoreruntime.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.TtlDurationValue
import scala.jdk.CollectionConverters.*
final case class TtlDuration(
    unit: zio.aws.sagemakerfeaturestoreruntime.model.TtlDurationUnit,
    value: TtlDurationValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TtlDuration = {
    import TtlDuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TtlDuration
      .builder()
      .unit(unit.unwrap)
      .value(TtlDurationValue.unwrap(value): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.TtlDuration.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.TtlDuration.wrap(buildAwsValue())
}
object TtlDuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TtlDuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakerfeaturestoreruntime.model.TtlDuration =
      zio.aws.sagemakerfeaturestoreruntime.model.TtlDuration(unit, value)
    def unit: zio.aws.sagemakerfeaturestoreruntime.model.TtlDurationUnit
    def value: TtlDurationValue
    def getUnit: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakerfeaturestoreruntime.model.TtlDurationUnit
    ] = ZIO.succeed(unit)
    def getValue: ZIO[Any, Nothing, TtlDurationValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TtlDuration
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.TtlDuration.ReadOnly {
    override val unit
        : zio.aws.sagemakerfeaturestoreruntime.model.TtlDurationUnit =
      zio.aws.sagemakerfeaturestoreruntime.model.TtlDurationUnit
        .wrap(impl.unit())
    override val value: TtlDurationValue =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .TtlDurationValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.TtlDuration
  ): zio.aws.sagemakerfeaturestoreruntime.model.TtlDuration.ReadOnly =
    new Wrapper(impl)
}
