package zio.aws.sagemakerfeaturestoreruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakerfeaturestoreruntime.model.primitives.{
  ValueAsString,
  FeatureGroupName
}
import scala.jdk.CollectionConverters.*
final case class DeleteRecordRequest(
    featureGroupName: FeatureGroupName,
    recordIdentifierValueAsString: ValueAsString,
    eventTime: ValueAsString,
    targetStores: Optional[
      Iterable[zio.aws.sagemakerfeaturestoreruntime.model.TargetStore]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest = {
    import DeleteRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
      .builder()
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .recordIdentifierValueAsString(
        ValueAsString.unwrap(recordIdentifierValueAsString): java.lang.String
      )
      .eventTime(ValueAsString.unwrap(eventTime): java.lang.String)
      .optionallyWith(
        targetStores.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.targetStoresWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest.ReadOnly =
    zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
      .wrap(buildAwsValue())
}
object DeleteRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest =
      zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest(
        featureGroupName,
        recordIdentifierValueAsString,
        eventTime,
        targetStores.map(value => value)
      )
    def featureGroupName: FeatureGroupName
    def recordIdentifierValueAsString: ValueAsString
    def eventTime: ValueAsString
    def targetStores
        : Optional[List[zio.aws.sagemakerfeaturestoreruntime.model.TargetStore]]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getRecordIdentifierValueAsString: ZIO[Any, Nothing, ValueAsString] =
      ZIO.succeed(recordIdentifierValueAsString)
    def getEventTime: ZIO[Any, Nothing, ValueAsString] = ZIO.succeed(eventTime)
    def getTargetStores: ZIO[Any, AwsError, List[
      zio.aws.sagemakerfeaturestoreruntime.model.TargetStore
    ]] = AwsError.unwrapOptionField("targetStores", targetStores)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
  ) extends zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest.ReadOnly {
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val recordIdentifierValueAsString: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.recordIdentifierValueAsString())
    override val eventTime: ValueAsString =
      zio.aws.sagemakerfeaturestoreruntime.model.primitives
        .ValueAsString(impl.eventTime())
    override val targetStores: Optional[
      List[zio.aws.sagemakerfeaturestoreruntime.model.TargetStore]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetStores())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakerfeaturestoreruntime.model.TargetStore.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.DeleteRecordRequest
  ): zio.aws.sagemakerfeaturestoreruntime.model.DeleteRecordRequest.ReadOnly =
    new Wrapper(impl)
}
